/*******************************************************************************
 **
 ** General Errors
 **
 **/

#pragma once

// General errors
#define kASNoError				0x00000000L
#define kASUnimplementedError	'!IMP'	
#define kASUserCanceledError	'stop'


/*******************************************************************************
 **
 ** SP Errors
 **
 **/

// General errors
#define kSPNoError							0x00000000L
#define kSPUnimplementedError				'!IMP'	
#define kSPUserCanceledError				'stop'
#define kSPOperationInterrupted				'intr'
#define	kSPLogicError						'fbar' // general programming error
		
// SPAccessSuite errors
#define kSPCantAcquirePluginError			'!Acq'
#define kSPCantReleasePluginError			'!Rel'
#define kSPPluginAlreadyReleasedError		'AlRl'

// SPAdaptsSuite errors
#define kSPAdapterAlreadyExistsError		'AdEx'
#define kSPBadAdapterListIteratorError		'BdAL'

// SPBasicSuite errors
#define kSPBadParameterError				'Parm'	

// Block debugging errors
#define kSPCantChangeBlockDebugNowError		'!Now'
#define kSPBlockDebugNotEnabledError		'!Nbl'

// SPBlocks errors
#define kSPOutOfMemoryError					0xFFFFFF6cL  /* -108, same as Mac memFullErr */
#define kSPBlockSizeOutOfRangeError			'BkRg'

// SPCaches errors
#define kSPPluginCachesFlushResponse		'pFls'
#define kSPPluginCouldntFlushResponse		kSPNoError;

// SPFiles errors
#define kSPTroubleAddingFilesError			'TAdd'
#define kSPBadFileListIteratorError			'BFIt'

// SPHost errors
#define kSPTroubleInitializingError			'TIni'	// Some non-descript problem encountered while starting up.
#define kHostCanceledStartupPluginsError 	'H!St'

// SPInterface errors
#define kSPNotASweetPeaPluginError			'NSPP'
#define kSPAlreadyInSPCallerError			'AISC'

// SPPlugins errors
#define kSPUnknownAdapterError				'?Adp'
#define kSPBadPluginListIteratorError		'PiLI'
#define kSPBadPluginHost					'PiH0'
#define kSPCantAddHostPluginError			'AdHo'
#define kSPPluginNotFound					'P!Fd'

// SPProperties errors
#define kSPCorruptPiPLError					'CPPL'
#define kSPBadPropertyListIteratorError		'BPrI'

// SPSuites errors
#define kSPSuiteNotFoundError				'S!Fd'	
#define kSPSuiteAlreadyExistsError			'SExi'	
#define kSPSuiteAlreadyReleasedError		'SRel'	
#define kSPBadSuiteListIteratorError		'SLIt'	
#define kSPBadSuiteInternalVersionError		'SIVs'	

